/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.infection.InfectionRegister;

public class InfectedEffect
extends Effect {
    private final UUID SPEED_MOD_UUID = UUID.fromString("05d68949-cb8b-4031-92a6-bd75e42b5cdd");
    private final String SPEED_MOD_NAME = ModDefinitions.getName("Infected");
    private final AttributeModifier SPEED_MOD = new AttributeModifier(this.SPEED_MOD_NAME, -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public InfectedEffect() {
        super(EffectType.HARMFUL, 0x440002);
    }

    public boolean shouldRender(EffectInstance effect) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, float z) {
    }

    public List<ItemStack> getCurativeItems() {
        return (Boolean)CommonConfigHandler.enableMobInfection.get() != false ? InfectionRegister.getCureList() : super.getCurativeItems();
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j(0.007f * (float)(amplifier + 1));
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return (Boolean)CommonConfigHandler.infectHunger.get();
    }

    public void func_111185_a(LivingEntity entity, AttributeModifierManager map, int amplifier) {
        ModifiableAttributeInstance attribute;
        if (amplifier > 0 && ((Boolean)CommonConfigHandler.infectSlowness.get()).booleanValue() && (attribute = map.func_233779_a_(Attributes.field_233821_d_)) != null) {
            attribute.func_188479_b(this.SPEED_MOD_UUID);
            attribute.func_233769_c_(new AttributeModifier(this.SPEED_MOD_UUID, this.SPEED_MOD_NAME + " " + amplifier, this.func_111183_a(amplifier - 1, this.SPEED_MOD), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public void func_111187_a(LivingEntity entity, AttributeModifierManager map, int amplifier) {
        ModifiableAttributeInstance attribute = map.func_233779_a_(Attributes.field_233821_d_);
        if (attribute != null) {
            attribute.func_188479_b(this.SPEED_MOD_UUID);
        }
    }
}

