/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.atlas.api.IOngoingEvent;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.capability.HordeEvent;

public interface IHordeEvent
extends IOngoingEvent<PlayerEntity> {
    public void spawnWave(PlayerEntity var1, int var2);

    public boolean isHordeDay(PlayerEntity var1);

    public boolean hasChanged();

    public void setPlayer(PlayerEntity var1);

    public void tryStartEvent(PlayerEntity var1, int var2, boolean var3);

    public void setNextDay(int var1);

    public int getNextDay();

    public void stopEvent(PlayerEntity var1, boolean var2);

    public void removeEntity(MobEntity var1);

    public void registerEntity(MobEntity var1);

    public void reset(ServerWorld var1);

    public static IHordeEvent createEvent() {
        return new HordeEvent();
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        protected IHordeEvent impl = new HordeEvent();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == Hordes.HORDE_EVENT ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return Hordes.HORDE_EVENT.getStorage().writeNBT(Hordes.HORDE_EVENT, (Object)this.impl, null);
        }

        public void deserializeNBT(INBT nbt) {
            Hordes.HORDE_EVENT.getStorage().readNBT(Hordes.HORDE_EVENT, (Object)this.impl, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IHordeEvent> {
        public INBT writeNBT(Capability<IHordeEvent> capability, IHordeEvent instance, Direction side) {
            return instance.writeToNBT(new CompoundNBT());
        }

        public void readNBT(Capability<IHordeEvent> capability, IHordeEvent instance, Direction side, INBT nbt) {
            instance.readFromNBT((CompoundNBT)nbt);
        }
    }
}

