/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.capability.HordeEvent;

public class HordeWorldData
extends WorldSavedData {
    public static final String DATA = "hordes_HordeEvent";
    private int nextDay = 0;
    protected World world = null;

    public HordeWorldData() {
        this(DATA);
    }

    public HordeWorldData(String data) {
        super(data);
    }

    public void func_76184_a(CompoundNBT nbt) {
        int next;
        if (nbt.func_74764_b("nextDay") && (next = nbt.func_74762_e("nextDay")) > this.nextDay) {
            this.nextDay = next;
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        nbt.func_74768_a("nextDay", this.nextDay);
        return nbt;
    }

    public int getNextDay() {
        return this.nextDay;
    }

    public void setNextDay(int nextDay) {
        this.nextDay = nextDay;
    }

    public Map<PlayerEntity, HordeEvent> getEvents() {
        HashMap<PlayerEntity, HordeEvent> events = new HashMap<PlayerEntity, HordeEvent>();
        if (!this.world.field_72995_K) {
            for (PlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                LazyOptional optional = player.getCapability(Hordes.HORDE_EVENT, null);
                if (!(optional.isPresent() & !player.func_233643_dh_())) continue;
                events.put(player, (HordeEvent)player.getCapability(Hordes.HORDE_EVENT, null).resolve().get());
            }
        }
        return events;
    }

    public void save() {
        this.func_76185_a();
        if (this.world instanceof ServerWorld) {
            ((ServerWorld)this.world).func_72863_F().func_217227_h().func_215757_a((WorldSavedData)this);
        }
    }

    public List<String> getDebugText() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.toString());
        out.add("Existing events: {");
        for (Map.Entry<PlayerEntity, HordeEvent> entry : this.getEvents().entrySet()) {
            out.add("\t" + entry.getValue().toString(entry.getKey()));
            out.addAll(entry.getValue().getEntityStrings());
        }
        out.add("}");
        return out;
    }

    public String toString() {
        return super.toString() + "[worldTime: " + this.world.func_72820_D() + ", nextDay=" + this.nextDay + "]";
    }

    public static HordeWorldData getData(ServerWorld world) {
        HordeWorldData data = (HordeWorldData)world.func_72863_F().func_217227_h().func_215752_a(() -> HordeWorldData.getCleanData(world), DATA);
        if (data == null) {
            data = HordeWorldData.getCleanData(world);
        }
        world.func_72863_F().func_217227_h().func_215757_a((WorldSavedData)data);
        return data;
    }

    public static HordeWorldData getCleanData(ServerWorld world) {
        HordeWorldData data = new HordeWorldData();
        data.world = world;
        int day = Math.round(world.func_72820_D() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
        double multiplier = Math.ceil(day / (Integer)CommonConfigHandler.hordeSpawnDays.get());
        if (!((Boolean)CommonConfigHandler.spawnFirstDay.get()).booleanValue() || day != 0) {
            multiplier += 1.0;
        }
        int nextDay = (int)Math.floor(multiplier * (double)((Integer)CommonConfigHandler.hordeSpawnDays.get()).intValue() + (double)world.field_73012_v.nextInt((Integer)CommonConfigHandler.hordeSpawnVariation.get() + 1));
        data.setNextDay(nextDay);
        return data;
    }
}

