/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.CommonUtils;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnEntry;

public class HordeEventRegister {
    protected static List<HordeSpawnEntry> spawnlist = new ArrayList<HordeSpawnEntry>();
    private static boolean tested = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readConfig() {
        Hordes.logInfo("Trying to read spawn table from config");
        if (CommonConfigHandler.hordeSpawnList == null) {
            Hordes.logError("Error reading config.", new NullPointerException("Spawn table has loaded as null"));
        } else if (((List)CommonConfigHandler.hordeSpawnList.get()).size() <= 0) {
            Hordes.logError("Error reading config.", new Exception("Spawn table in config is empty"));
        }
        for (String name : (List)CommonConfigHandler.hordeSpawnList.get()) {
            try {
                EntityType type = null;
                int weight = 0;
                int minDay = 0;
                int maxDay = 0;
                CompoundNBT nbt = null;
                if (name.contains(":")) {
                    ResourceLocation loc;
                    String[] nameSplit = name.split("-");
                    if (nameSplit.length <= 1) throw new Exception("Entry " + name + " is not in the correct format");
                    if (nameSplit[0].contains("{")) {
                        String nbtstring = nameSplit[0].substring(nameSplit[0].indexOf("{"));
                        nameSplit[0] = nameSplit[0].substring(0, nameSplit[0].indexOf("{"));
                        nbt = CommonUtils.parseNBT(name, nbtstring);
                    }
                    if (!ForgeRegistries.ENTITIES.containsKey(loc = new ResourceLocation(nameSplit[0]))) throw new Exception("Entity " + name + " is not registered");
                    type = (EntityType)ForgeRegistries.ENTITIES.getValue(loc);
                    try {
                        weight = Integer.valueOf(nameSplit[1]);
                    }
                    catch (Exception e) {
                        throw new Exception("Entity " + name + " has weight value " + nameSplit[1] + " which is not a valid integer");
                    }
                    try {
                        minDay = Integer.valueOf(nameSplit[2]);
                    }
                    catch (Exception e) {
                        throw new Exception("Entity " + name + " has min day value " + nameSplit[2] + " which is not a valid integer");
                    }
                    if (nameSplit.length > 3) {
                        try {
                            maxDay = Integer.valueOf(nameSplit[3]);
                        }
                        catch (Exception e) {
                            throw new Exception("Entity " + name + " has max day value " + nameSplit[3] + " which is not a valid integer");
                        }
                    }
                }
                if (type == null) {
                    throw new Exception("Entry " + name + " is not in the correct format");
                }
                HordeSpawnEntry entry = new HordeSpawnEntry(type, weight, minDay, maxDay);
                if (nbt != null) {
                    entry.setNBT(nbt);
                }
                spawnlist.add(entry);
                Hordes.logInfo("Loaded entity " + name + " as " + type.toString() + " with weight " + weight + ", min day " + minDay + " and max day " + maxDay);
            }
            catch (Exception e) {
                Hordes.logError("Error adding entity " + name + " " + e.getCause() + " " + e.getMessage(), e);
            }
        }
    }

    public static WeightedOutputs<HordeSpawnEntry> getSpawnTable(int day) {
        ArrayList<AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>> spawnmap = new ArrayList<AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>>();
        for (HordeSpawnEntry entry : spawnlist) {
            if (entry.getMinDay() > day || entry.getMaxDay() != 0 && entry.getMaxDay() < day) continue;
            spawnmap.add(new AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>(entry, entry.getWeight()));
            Hordes.logInfo("Adding entry " + entry.toString() + " to hordespawn on day " + day);
        }
        return new WeightedOutputs(1, spawnmap);
    }

    public static List<HordeSpawnEntry> getEntriesFor(MobEntity entity) {
        return HordeEventRegister.getEntriesFor(entity.func_200600_R());
    }

    public static List<HordeSpawnEntry> getEntriesFor(EntityType<?> type) {
        ArrayList<HordeSpawnEntry> list = new ArrayList<HordeSpawnEntry>();
        for (HordeSpawnEntry entry : spawnlist) {
            if (entry.getEntity() != type) continue;
            list.add(entry);
        }
        return list;
    }

    public static HordeSpawnEntry getEntryFor(MobEntity entity, int day) {
        if (!tested) {
            HordeEventRegister.testEntries();
        }
        for (HordeSpawnEntry entry : HordeEventRegister.getEntriesFor(entity)) {
            if (entry.getMinDay() > day || entry.getMaxDay() != 0 && entry.getMaxDay() < day) continue;
            return entry;
        }
        return null;
    }

    private static void testEntries() {
        ArrayList<HordeSpawnEntry> toRemove = new ArrayList<HordeSpawnEntry>();
        for (HordeSpawnEntry entry : spawnlist) {
            try {
                Entity entity = entry.getEntity().func_200721_a((World)ServerLifecycleHooks.getCurrentServer().func_241755_D_());
                if (entity instanceof MobEntity) continue;
                toRemove.add(entry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (HordeSpawnEntry type : toRemove) {
            spawnlist.remove(type);
        }
        tested = true;
    }
}

