/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.entities;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.entities.IZombiePlayer;
import net.smileycorp.hordes.common.infection.HordesInfection;

public class ZombiePlayerEntity
extends ZombieEntity
implements IZombiePlayer {
    protected static final DataParameter<Optional<UUID>> PLAYER_UUID = EntityDataManager.func_187226_a(ZombiePlayerEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SHOW_CAPE = EntityDataManager.func_187226_a(ZombiePlayerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected NonNullList<ItemStack> playerItems = NonNullList.func_191196_a();
    protected UUID field_96093_i;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;

    public ZombiePlayerEntity(EntityType<? extends ZombiePlayerEntity> type, World world) {
        super(type, world);
    }

    public ZombiePlayerEntity(World world) {
        this((EntityType<? extends ZombiePlayerEntity>)((EntityType)HordesInfection.ZOMBIE_PLAYER.get()), world);
    }

    public ZombiePlayerEntity(PlayerEntity player) {
        this(player.field_70170_p);
        this.setPlayer(player);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_UUID, Optional.of(UUID.fromString("1512ce82-00e5-441a-9774-f46d9b7badfb")));
        this.field_70180_af.func_187214_a(SHOW_CAPE, (Object)true);
    }

    @Override
    public void setPlayer(PlayerEntity player) {
        if (player == null) {
            return;
        }
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = slot.func_188453_a() == EquipmentSlotType.Group.ARMOR ? (ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b()) : (slot == EquipmentSlotType.MAINHAND ? player.func_184614_ca() : player.func_184592_cb());
            this.func_184201_a(slot, stack);
        }
        this.setPlayer(player.func_146103_bH());
    }

    @Override
    public void setPlayer(String username) {
        this.setPlayer(ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152655_a(username));
    }

    @Override
    public void setPlayer(UUID uuid) {
        this.setPlayer(ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(uuid));
    }

    @Override
    public void setPlayer(GameProfile profile) {
        if (profile == null) {
            return;
        }
        this.field_96093_i = profile.getId();
        this.func_200203_b((ITextComponent)new StringTextComponent(profile.getName()));
        this.field_70180_af.func_187227_b(PLAYER_UUID, Optional.of(this.field_96093_i));
    }

    @Override
    public UUID getPlayerUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER_UUID)).get();
    }

    @Override
    public void setInventory(Collection<ItemEntity> list) {
        this.playerItems.clear();
        for (ItemEntity item : list) {
            ItemStack stack = item.func_92059_d();
            item.func_70106_y();
            if (stack == null) continue;
            this.playerItems.add((Object)stack.func_77946_l());
        }
    }

    @Override
    public void setInventory(NonNullList<ItemStack> list) {
        this.playerItems.clear();
        this.playerItems.addAll(list);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.playerItems;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        for (ItemStack stack : this.playerItems) {
            if (stack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)stack)) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }

    protected void func_207302_dI() {
        if (((Boolean)CommonConfigHandler.drownedPlayers.get()).booleanValue()) {
            ZombieEntity drowned = (ZombieEntity)this.func_233656_b_((EntityType)HordesInfection.DROWNED_PLAYER.get(), true);
            if (drowned != null) {
                drowned.func_207304_a(drowned.field_70170_p.func_175649_E(drowned.func_233580_cy_()).func_180170_c());
                drowned.func_146070_a(drowned.func_204900_dz() && this.func_146072_bX());
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)drowned);
                if (drowned instanceof IZombiePlayer) {
                    ((IZombiePlayer)drowned).copyFrom(this);
                }
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_217378_a((PlayerEntity)null, 1040, this.func_233580_cy_(), 0);
            }
        }
    }

    public boolean func_190730_o() {
        return (Boolean)CommonConfigHandler.zombiePlayersBurn.get();
    }

    public boolean func_230279_az_() {
        return (Boolean)CommonConfigHandler.zombiePlayersFireImmune.get();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_96093_i != null) {
            compound.func_74778_a("player", this.field_96093_i.toString());
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.playerItems);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("player")) {
            this.field_96093_i = UUID.fromString(compound.func_74779_i("player"));
        }
        NonNullList read = NonNullList.func_191197_a((int)compound.func_150295_c("Items", 10).size(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)read);
        this.playerItems = read;
    }

    public ITextComponent func_145748_c_() {
        TranslationTextComponent textcomponentstring = new TranslationTextComponent(ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)new StringTextComponent("entity.hordes.ZombiePlayer.chat")).getString(), new Object[]{ScorePlayerTeam.func_237500_a_((Team)this.func_96124_cp(), (ITextComponent)this.func_200200_C_())});
        textcomponentstring.func_150256_b().func_240716_a_(this.func_174823_aP());
        textcomponentstring.func_150256_b().func_240714_a_(this.func_70022_Q());
        return textcomponentstring;
    }

    @Override
    public void copyFrom(IZombiePlayer entity) {
        this.setPlayer(entity.getPlayerUUID());
        this.setInventory(entity.getInventory());
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = ((MobEntity)entity).func_184582_a(slot);
            this.func_184201_a(slot, stack);
        }
        this.field_70180_af.func_187227_b(SHOW_CAPE, (Object)entity.displayCape());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.moveCloak(this);
    }

    @Override
    public void setDisplayCape(boolean display) {
        this.field_70180_af.func_187227_b(SHOW_CAPE, (Object)display);
    }

    @Override
    public boolean displayCape() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOW_CAPE);
    }

    @Override
    public double getXCloakO() {
        return this.xCloakO;
    }

    @Override
    public double getYCloakO() {
        return this.yCloakO;
    }

    @Override
    public double getZCloakO() {
        return this.zCloakO;
    }

    @Override
    public double getXCloak() {
        return this.xCloak;
    }

    @Override
    public double getYCloak() {
        return this.yCloak;
    }

    @Override
    public double getZCloak() {
        return this.zCloak;
    }

    @Override
    public void setXCloakO(double value) {
        this.xCloakO = value;
    }

    @Override
    public void setYCloakO(double value) {
        this.yCloakO = value;
    }

    @Override
    public void setZCloakO(double value) {
        this.zCloakO = value;
    }

    @Override
    public void setXCloak(double value) {
        this.xCloak = value;
    }

    @Override
    public void setYCloak(double value) {
        this.yCloak = value;
    }

    @Override
    public void setZCloak(double value) {
        this.zCloak = value;
    }
}

