/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.potion.Effect;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.capability.IZombifyPlayer;
import net.smileycorp.hordes.common.entities.IZombiePlayer;
import net.smileycorp.hordes.common.infection.HordesInfection;

@Mod.EventBusSubscriber(modid="hordes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity != null) {
            LazyOptional optional;
            World world = entity.field_70170_p;
            if (!world.field_72995_K && entity instanceof PlayerEntity & !(entity instanceof FakePlayer) && (entity.func_70644_a((Effect)HordesInfection.INFECTED.get()) && ((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue() || ((Boolean)CommonConfigHandler.zombieGraves.get()).booleanValue() || entity.func_204231_K() && ((Boolean)CommonConfigHandler.drownedGraves.get()).booleanValue()) && (optional = entity.getCapability(Hordes.ZOMBIFY_PLAYER, null)).isPresent()) {
                ((IZombifyPlayer)optional.resolve().get()).createZombie((PlayerEntity)entity);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onDrop(LivingDropsEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            IZombifyPlayer cap;
            MobEntity zombie;
            LazyOptional optional;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            World world = player.field_70170_p;
            if (!world.field_72995_K & !(player instanceof FakePlayer) && (player.func_70644_a((Effect)HordesInfection.INFECTED.get()) && ((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue() || ((Boolean)CommonConfigHandler.zombieGraves.get()).booleanValue()) && (optional = player.getCapability(Hordes.ZOMBIFY_PLAYER, null)).isPresent() && (zombie = (cap = (IZombifyPlayer)optional.resolve().get()).getZombie()) != null) {
                Collection drops = event.getDrops();
                ((IZombiePlayer)zombie).setInventory(drops);
                zombie.func_110163_bv();
                world.func_217376_c((Entity)zombie);
                drops.clear();
                cap.clearZombie();
                event.setCanceled(true);
                player.func_195063_d((Effect)HordesInfection.INFECTED.get());
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity & !(entity instanceof FakePlayer)) {
            event.addCapability(ModDefinitions.getResource("Zombify"), (ICapabilityProvider)new IZombifyPlayer.Provider());
        }
    }

    @SubscribeEvent
    public void entityConvert(LivingConversionEvent.Post event) {
        LivingEntity before = event.getEntityLiving();
        if (before.field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity after = event.getOutcome();
        if (before instanceof AbstractHorseEntity && after instanceof AbstractHorseEntity) {
            Inventory beforeInv = ((AbstractHorseEntity)before).field_110296_bG;
            Inventory afterInv = ((AbstractHorseEntity)after).field_110296_bG;
            for (int i = 0; i < Math.min(beforeInv.func_70302_i_(), afterInv.func_70302_i_()); ++i) {
                afterInv.func_70299_a(i, beforeInv.func_70301_a(i).func_77946_l());
            }
        }
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HordesInfection.ZOMBIE_PLAYER.get(), ZombieEntity.func_234342_eQ_().func_233813_a_());
        event.put((EntityType)HordesInfection.DROWNED_PLAYER.get(), DrownedEntity.func_234342_eQ_().func_233813_a_());
    }
}

