/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.utils.LogHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class Module {
    private final ForgeConfigSpec.ConfigValue<Boolean> enabledConfig;
    private boolean enabled;
    private final boolean canBeDisabled;
    private final String name;
    private final String description;

    public Module(ForgeConfigSpec.Builder builder, boolean enabledByDefault, boolean canBeDisabled) {
        if (!this.getClass().isAnnotationPresent(Label.class)) {
            LogHelper.error(String.format("%s is missing the Label Annotation.", this.getClass().getName()), new Object[0]);
        }
        this.name = this.getClass().getAnnotation(Label.class).name();
        this.description = this.getClass().getAnnotation(Label.class).description();
        this.canBeDisabled = canBeDisabled;
        this.enabledConfig = canBeDisabled ? (!this.description.equals("") ? builder.comment(this.description).define("Enable " + this.name + " module", enabledByDefault) : builder.define("Enable " + this.name, enabledByDefault)) : null;
    }

    public Module(ForgeConfigSpec.Builder builder, boolean enabledByDefault) {
        this(builder, enabledByDefault, true);
    }

    public Module(ForgeConfigSpec.Builder builder) {
        this(builder, true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void loadConfig() {
        this.enabled = this.canBeDisabled ? (Boolean)this.enabledConfig.get() : true;
    }

    public void pushConfig(ForgeConfigSpec.Builder builder) {
        if (!this.description.equals("")) {
            builder.comment(this.getDescription()).push(this.getName());
        } else {
            builder.push(this.getName());
        }
    }
}

