/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.feature;

import insane96mcp.enhancedai.modules.zombie.ai.AIZombiePearler;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.BlacklistConfig;
import insane96mcp.insanelib.utils.IdTagMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Pearler Zombie", description="Let zombies use ender pearls. Either put ender pearls in main or off hand and when far enough from the player they will throw it.")
public class PearlerZombieFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> equipEnderPearlChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> enderPearlAmountConfig;
    private final BlacklistConfig entityBlacklistConfig;
    public double equipEnderPearlChance = 0.04;
    public int enderPearlAmount = 2;
    public ArrayList<IdTagMatcher> entityBlacklist;
    public boolean entityBlacklistAsWhitelist;

    public PearlerZombieFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.equipEnderPearlChanceConfig = Config.builder.comment("Chance for a Zombie to spawn with an ender pearl in the off hand. I highly recommend using something like Mobs Properties Randomness to have more control over mobs equipment.").defineInRange("Equip Ender Pearl Chance", this.equipEnderPearlChance, 0.0, 1.0);
        this.enderPearlAmountConfig = Config.builder.comment("How many ender pearls will Zombies spawn with.").defineInRange("Ender Pearl Amount", this.enderPearlAmount, 1, 16);
        this.entityBlacklistConfig = new BlacklistConfig(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Pearler AI", Collections.emptyList(), false);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.equipEnderPearlChance = (Double)this.equipEnderPearlChanceConfig.get();
        this.enderPearlAmount = (Integer)this.enderPearlAmountConfig.get();
        this.entityBlacklist = IdTagMatcher.parseStringList((List)((List)this.entityBlacklistConfig.listConfig.get()));
        this.entityBlacklistAsWhitelist = (Boolean)this.entityBlacklistConfig.listAsWhitelistConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ZombieEntity)) {
            return;
        }
        ZombieEntity zombie = (ZombieEntity)event.getEntity();
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.entityBlacklist) {
            if (!blacklistEntry.matchesEntity((Entity)zombie)) continue;
            if (!this.entityBlacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        if (isInBlacklist || !isInWhitelist && this.entityBlacklistAsWhitelist) {
            return;
        }
        if (event.getWorld().field_73012_v.nextDouble() < this.equipEnderPearlChance) {
            zombie.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_151079_bi, this.enderPearlAmount));
        }
        zombie.field_70714_bg.func_75776_a(2, (Goal)new AIZombiePearler(zombie));
    }
}

