/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.feature;

import insane96mcp.enhancedai.modules.zombie.ai.AIZombieDigger;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.BlacklistConfig;
import insane96mcp.insanelib.utils.IdTagMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Digger Zombie")
public class DiggerZombieFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> diggerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> diggerToolOnlyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> diggerProperToolOnlyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> blacklistTileEntitiesConfig;
    private final ForgeConfigSpec.ConfigValue<Double> miningSpeedMultiplierConfig;
    private final BlacklistConfig blockBlacklistConfig;
    private final BlacklistConfig entityBlacklistConfig;
    public double diggerChance = 0.05;
    public boolean diggerToolOnly = false;
    public boolean diggerProperToolOnly = false;
    public double miningSpeedMultiplier = 1.0;
    public boolean blacklistTileEntities = false;
    public ArrayList<IdTagMatcher> blockBlacklist;
    public boolean blockBlacklistAsWhitelist;
    public ArrayList<IdTagMatcher> entityBlacklist;
    public boolean entityBlacklistAsWhitelist;

    public DiggerZombieFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.diggerChanceConfig = Config.builder.comment("Chance for a Zombie to spawn with the digger ability").defineInRange("Digger Chance", this.diggerChance, 0.0, 1.0);
        this.diggerToolOnlyConfig = Config.builder.comment("Zombies with Digger AI will mine only if they have a tool in the off-hand").define("Digger Tool Only", this.diggerToolOnly);
        this.diggerProperToolOnlyConfig = Config.builder.comment("Zombies with Digger AI will mine only if their off-hand tool can mine targeted blocks (e.g. zombies with shovels will not mine stone). Blocks that require no tool (e.g. planks) will be minable.").define("Digger Proper Tool Only", this.diggerProperToolOnly);
        this.miningSpeedMultiplierConfig = Config.builder.comment("Multiplier for digger zombies mining speed. E.g. with this set to 2, zombies will take twice the time to mine a block.").defineInRange("Digger Speed Multiplier", this.miningSpeedMultiplier, 0.0, 128.0);
        this.blacklistTileEntitiesConfig = Config.builder.comment("Zombies with Digger AI will not be able to break tile entities").define("Blacklist Tile Entities", this.blacklistTileEntities);
        this.blockBlacklistConfig = new BlacklistConfig(Config.builder, "Block Blacklist", "Blocks in here will not be minable by zombies (or will be the only minable in case it's whitelist)", Collections.emptyList(), false);
        this.entityBlacklistConfig = new BlacklistConfig(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Digger AI", Collections.emptyList(), false);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.diggerChance = (Double)this.diggerChanceConfig.get();
        this.diggerToolOnly = (Boolean)this.diggerToolOnlyConfig.get();
        this.diggerProperToolOnly = (Boolean)this.diggerProperToolOnlyConfig.get();
        this.miningSpeedMultiplier = (Double)this.miningSpeedMultiplierConfig.get();
        this.blacklistTileEntities = (Boolean)this.blacklistTileEntitiesConfig.get();
        this.blockBlacklist = IdTagMatcher.parseStringList((List)((List)this.blockBlacklistConfig.listConfig.get()));
        this.blockBlacklistAsWhitelist = (Boolean)this.blockBlacklistConfig.listAsWhitelistConfig.get();
        this.entityBlacklist = IdTagMatcher.parseStringList((List)((List)this.entityBlacklistConfig.listConfig.get()));
        this.entityBlacklistAsWhitelist = (Boolean)this.entityBlacklistConfig.listAsWhitelistConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        boolean miner;
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ZombieEntity)) {
            return;
        }
        ZombieEntity zombie = (ZombieEntity)event.getEntity();
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.entityBlacklist) {
            if (!blacklistEntry.matchesEntity((Entity)zombie)) continue;
            if (!this.entityBlacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        if (isInBlacklist || !isInWhitelist && this.entityBlacklistAsWhitelist) {
            return;
        }
        boolean processed = zombie.getPersistentData().func_74767_n("enhancedai:processed");
        boolean bl = miner = zombie.field_70170_p.field_73012_v.nextDouble() < this.diggerChance;
        if (processed) {
            miner = zombie.getPersistentData().func_74767_n("enhancedai:miner");
        } else {
            zombie.getPersistentData().func_74757_a("enhancedai:miner", miner);
            zombie.getPersistentData().func_74757_a("enhancedai:processed", true);
        }
        if (miner) {
            zombie.field_70714_bg.func_75776_a(1, (Goal)new AIZombieDigger(zombie, this.diggerToolOnly, this.diggerProperToolOnly));
        }
    }
}

