/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.spider.feature;

import insane96mcp.enhancedai.modules.spider.ai.AISpiderWebThrow;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.BlacklistConfig;
import insane96mcp.insanelib.utils.IdTagMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Throwing Web", description="Makes spiders throw a web at a player, slowing them.")
public class ThrowingWebFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> webThrowChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> destroyWebAfterConfig;
    private final ForgeConfigSpec.ConfigValue<Double> thrownWebDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> throwingCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Double> minDistanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxDistanceConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> slownessTimeConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> slownessAmplifierConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> stackSlownessConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxSlownessConfig;
    private final BlacklistConfig entityBlacklistConfig;
    public double webThrowChance = 0.1;
    public int destroyWebAfter = 100;
    public double thrownWebDamage = 5.0;
    public int throwingCooldown = 50;
    public double minDistance = 2.5;
    public double maxDistance = 64.0;
    public int slownessTime = 120;
    public int slownessAmplifier = 2;
    public boolean stackSlowness = true;
    public int maxSlowness = 6;
    public ArrayList<IdTagMatcher> entityBlacklist;
    public boolean entityBlacklistAsWhitelist;

    public ThrowingWebFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.webThrowChanceConfig = Config.builder.comment("Chance for a Spider to spawn with the ability to throw webs at the target.").defineInRange("Web Throw Chance", this.webThrowChance, 0.0, 1.0);
        this.destroyWebAfterConfig = Config.builder.comment("After how many ticks will the web projectile's cobweb be destroyed?").defineInRange("Destroy Web After", this.destroyWebAfter, 0, 6000);
        this.thrownWebDamageConfig = Config.builder.comment("Damage when the projectiles hits a mob. The damage is set for normal difficulty. Hard difficulty gets +50% damage and Easy gets (-50% + 1) damage.").defineInRange("Web Throw Chance", this.thrownWebDamage, 0.0, 128.0);
        this.throwingCooldownConfig = Config.builder.comment("Every how many ticks do spiders throw the projectile").defineInRange("Projectile cooldown", this.throwingCooldown, 1, 1200);
        this.minDistanceConfig = Config.builder.comment("Minimum distance required for the spider to throw webs. Setting this to 0 will make the spider throw webs even when attacking the player.").defineInRange("Min Distance", this.minDistance, 0.0, 64.0);
        this.maxDistanceConfig = Config.builder.comment("Maximum distance at which the spider will throw webs.").defineInRange("Max Distance", this.maxDistance, 0.0, 64.0);
        Config.builder.push("Slowness");
        this.slownessTimeConfig = Config.builder.comment("How many ticks of slowness are applied to the target hit by the web?").defineInRange("Slowness Tick", this.slownessTime, 0, 6000);
        this.slownessAmplifierConfig = Config.builder.comment("How many levels of slowness are applied to the target hit by the web?").defineInRange("Slowness Amplifier", this.slownessAmplifier, 0, 128);
        this.stackSlownessConfig = Config.builder.comment("Should multiple hits on a target with slowness increase the level of Slowness? (This works with any type of slowness)").define("Stack Slowness Amplifier", this.stackSlowness);
        this.maxSlownessConfig = Config.builder.comment("How many max levels of slowness can be applied to the target?").defineInRange("Max Slowness Amplifier", this.maxSlowness, 0, 128);
        Config.builder.pop();
        this.entityBlacklistConfig = new BlacklistConfig(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Throwing Web AI", Collections.emptyList(), false);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.webThrowChance = (Double)this.webThrowChanceConfig.get();
        this.destroyWebAfter = (Integer)this.destroyWebAfterConfig.get();
        this.thrownWebDamage = (Double)this.thrownWebDamageConfig.get();
        this.throwingCooldown = (Integer)this.throwingCooldownConfig.get();
        this.minDistance = (Double)this.minDistanceConfig.get();
        this.maxDistance = (Double)this.maxDistanceConfig.get();
        this.slownessTime = (Integer)this.slownessTimeConfig.get();
        this.slownessAmplifier = (Integer)this.slownessAmplifierConfig.get();
        this.stackSlowness = (Boolean)this.stackSlownessConfig.get();
        this.maxSlowness = (Integer)this.maxSlownessConfig.get();
        this.entityBlacklist = IdTagMatcher.parseStringList((List)((List)this.entityBlacklistConfig.listConfig.get()));
        this.entityBlacklistAsWhitelist = (Boolean)this.entityBlacklistConfig.listAsWhitelistConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        boolean webThrower;
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof SpiderEntity)) {
            return;
        }
        SpiderEntity spider = (SpiderEntity)event.getEntity();
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.entityBlacklist) {
            if (!blacklistEntry.matchesEntity((Entity)spider)) continue;
            if (!this.entityBlacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        if (isInBlacklist || !isInWhitelist && this.entityBlacklistAsWhitelist) {
            return;
        }
        boolean processed = spider.getPersistentData().func_74767_n("enhancedai:processed");
        boolean bl = webThrower = spider.field_70170_p.field_73012_v.nextDouble() < this.webThrowChance;
        if (processed) {
            webThrower = spider.getPersistentData().func_74767_n("enhancedai:web_thrower");
        } else {
            spider.getPersistentData().func_74757_a("enhancedai:web_thrower", webThrower);
            spider.getPersistentData().func_74757_a("enhancedai:processed", true);
        }
        if (webThrower) {
            spider.field_70714_bg.func_75776_a(2, (Goal)new AISpiderWebThrow(spider));
        }
    }

    public void applySlowness(LivingEntity entity) {
        EffectInstance slowness = entity.func_70660_b(Effects.field_76421_d);
        if (slowness == null) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slownessTime, this.slownessAmplifier - 1, true, true, true));
        } else if (this.stackSlowness) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slownessTime, Math.min(slowness.func_76458_c() + this.slownessAmplifier, this.maxSlowness - 1), true, true, true));
        }
    }
}

