/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.spider.feature;

import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.BlacklistConfig;
import insane96mcp.insanelib.utils.IdTagMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Miscellaneous", description="Various small changes to Spiders.")
public class MiscFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> fallDamageReductionConfig;
    private final BlacklistConfig entityBlacklistConfig;
    public double fallDamageReduction = 0.9;
    public ArrayList<IdTagMatcher> entityBlacklist;
    public boolean entityBlacklistAsWhitelist;

    public MiscFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.fallDamageReductionConfig = Config.builder.comment("Percentage reduction of the fall damage taken by spiders.").defineInRange("Fall Damage Reduction", this.fallDamageReduction, 0.0, 1.0);
        this.entityBlacklistConfig = new BlacklistConfig(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Throwing Web AI", Collections.emptyList(), false);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.fallDamageReduction = (Double)this.fallDamageReductionConfig.get();
        this.entityBlacklist = IdTagMatcher.parseStringList((List)((List)this.entityBlacklistConfig.listConfig.get()));
        this.entityBlacklistAsWhitelist = (Boolean)this.entityBlacklistConfig.listAsWhitelistConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.fallDamageReduction == 0.0) {
            return;
        }
        if (!event.getSource().equals(DamageSource.field_76379_h)) {
            return;
        }
        if (!(event.getEntity() instanceof SpiderEntity)) {
            return;
        }
        SpiderEntity spider = (SpiderEntity)event.getEntity();
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.entityBlacklist) {
            if (!blacklistEntry.matchesEntity((Entity)spider)) continue;
            if (!this.entityBlacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        if (isInBlacklist || !isInWhitelist && this.entityBlacklistAsWhitelist) {
            return;
        }
        event.setAmount((float)((double)event.getAmount() * this.fallDamageReduction));
    }
}

