/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.enhancedai.modules.base.ai.AIAvoidEntityGoal;
import insane96mcp.enhancedai.modules.skeleton.ai.AIRangedBowAttackGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.BlacklistConfig;
import insane96mcp.insanelib.utils.IdTagMatcher;
import insane96mcp.insanelib.utils.RandomHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;

@Label(name="Skeleton Shoot", description="Skeletons are more precise when shooting and strafing is removed, can hit a target from up to 64 blocks and try to stay away from the target.")
public class SkeletonAIFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> minShootingRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxShootingRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Double> strafeChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> arrowInaccuracyConfig;
    private final BlacklistConfig entityBlacklistConfig;
    private final ForgeConfigSpec.ConfigValue<Double> avoidPlayerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> attackWhenAvoidingChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeSpeedNearConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeSpeedFarConfig;
    public int minShootingRange = 24;
    public int maxShootingRange = 48;
    public double strafeChance = 0.333;
    public double arrowInaccuracy = 2.0;
    public ArrayList<IdTagMatcher> entityBlacklist;
    public boolean entityBlacklistAsWhitelist;
    public double avoidPlayerChance = 0.5;
    public double attackWhenAvoidingChance = 0.5;
    public double fleeSpeedNear = 1.6;
    public double fleeSpeedFar = 1.3;

    public SkeletonAIFeature(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.minShootingRangeConfig = Config.builder.comment("The min range from where a skeleton will shoot a player").defineInRange("Min Shooting Range", this.minShootingRange, 1, 64);
        this.maxShootingRangeConfig = Config.builder.comment("The max range from where a skeleton will shoot a player").defineInRange("Max Shooting Range", this.maxShootingRange, 1, 64);
        this.strafeChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn with the ability to strafe (like vanilla)").defineInRange("Strafe chance", this.strafeChance, 0.0, 1.0);
        this.arrowInaccuracyConfig = Config.builder.comment("How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.").defineInRange("Arrow Inaccuracy", this.arrowInaccuracy, 0.0, 30.0);
        this.entityBlacklistConfig = new BlacklistConfig(Config.builder, "Entity Blacklist", "Entities that shouldn't get the enhanced Shoot AI", Arrays.asList("quark:forgotten"), false);
        Config.builder.push("Flee from Target");
        this.avoidPlayerChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn with the ability to avoid the player").defineInRange("Avoid Player chance", this.avoidPlayerChance, 0.0, 1.0);
        this.attackWhenAvoidingChanceConfig = Config.builder.comment("Chance for a Skeleton to attack while running from a player").defineInRange("Attack When Avoiding Chance", this.attackWhenAvoidingChance, 0.0, 1.0);
        this.fleeSpeedNearConfig = Config.builder.comment("Speed multiplier when the skeleton avoids the player and it's within 7 blocks from him.").defineInRange("Flee speed Multiplier Near", this.fleeSpeedNear, 0.0, 4.0);
        this.fleeSpeedFarConfig = Config.builder.comment("Speed multiplier when the skeleton avoids the player and it's farther than 7 blocks from him.").defineInRange("Flee speed Multiplier Far", this.fleeSpeedFar, 0.0, 4.0);
        Config.builder.pop();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.minShootingRange = (Integer)this.minShootingRangeConfig.get();
        this.maxShootingRange = (Integer)this.maxShootingRangeConfig.get();
        this.strafeChance = (Double)this.strafeChanceConfig.get();
        this.arrowInaccuracy = (Double)this.arrowInaccuracyConfig.get();
        this.entityBlacklist = IdTagMatcher.parseStringList((List)((List)this.entityBlacklistConfig.listConfig.get()));
        this.entityBlacklistAsWhitelist = (Boolean)this.entityBlacklistConfig.listAsWhitelistConfig.get();
        this.avoidPlayerChance = (Double)this.avoidPlayerChanceConfig.get();
        this.attackWhenAvoidingChance = (Double)this.attackWhenAvoidingChanceConfig.get();
        this.fleeSpeedNear = (Double)this.fleeSpeedNearConfig.get();
        this.fleeSpeedFar = (Double)this.fleeSpeedFarConfig.get();
    }

    public void reassessWeaponGoal(AbstractSkeletonEntity skeleton) {
        boolean attackWhenAvoiding;
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.entityBlacklist) {
            if (!blacklistEntry.matchesEntity((Entity)skeleton)) continue;
            if (!this.entityBlacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        if (isInBlacklist || !isInWhitelist && this.entityBlacklistAsWhitelist) {
            return;
        }
        boolean processed = skeleton.getPersistentData().func_74767_n("enhancedai:processed");
        boolean strafe = skeleton.field_70170_p.field_73012_v.nextDouble() < this.strafeChance;
        boolean avoidTarget = skeleton.field_70170_p.field_73012_v.nextDouble() < this.avoidPlayerChance;
        boolean bl = attackWhenAvoiding = skeleton.field_70170_p.field_73012_v.nextDouble() < this.attackWhenAvoidingChance;
        if (processed) {
            strafe = skeleton.getPersistentData().func_74767_n("enhancedai:strafe");
            avoidTarget = skeleton.getPersistentData().func_74767_n("enhancedai:avoid_target");
            attackWhenAvoiding = skeleton.getPersistentData().func_74767_n("enhancedai:attack_when_avoiding");
        } else {
            skeleton.getPersistentData().func_74757_a("enhancedai:strafe", strafe);
            skeleton.getPersistentData().func_74757_a("enhancedai:avoid_target", avoidTarget);
            skeleton.getPersistentData().func_74757_a("enhancedai:attack_when_avoiding", attackWhenAvoiding);
            skeleton.getPersistentData().func_74757_a("enhancedai:processed", true);
        }
        boolean hasAIArrowAttack = false;
        for (PrioritizedGoal prioritizedGoal : skeleton.field_70714_bg.field_220892_d) {
            if (!prioritizedGoal.func_220772_j().equals(skeleton.field_85037_d)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.field_70714_bg.field_220892_d.stream().map(PrioritizedGoal::func_220772_j).filter(g -> g instanceof AIAvoidEntityGoal).collect(Collectors.toList());
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.field_70714_bg).func_85156_a(arg_0));
        if (hasAIArrowAttack) {
            AIRangedBowAttackGoal<AbstractSkeletonEntity> rangedBowAttackGoal = new AIRangedBowAttackGoal<AbstractSkeletonEntity>(skeleton, 1.0, 20, RandomHelper.getInt((Random)skeleton.field_70170_p.field_73012_v, (int)this.minShootingRange, (int)this.maxShootingRange), strafe);
            skeleton.field_70714_bg.func_75776_a(2, rangedBowAttackGoal);
            if (avoidTarget) {
                AIAvoidEntityGoal<PlayerEntity> avoidEntityGoal = new AIAvoidEntityGoal<PlayerEntity>((CreatureEntity)skeleton, PlayerEntity.class, 12.0f, this.fleeSpeedFar, this.fleeSpeedNear);
                avoidEntityGoal.setAttackWhenRunning(attackWhenAvoiding);
                skeleton.field_70714_bg.func_75776_a(1, avoidEntityGoal);
            }
        }
    }
}

