/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.AINearestAttackableTargetGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.BlacklistConfig;
import insane96mcp.insanelib.utils.IdTagMatcher;
import insane96mcp.insanelib.utils.MCUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Targeting", description="Change how mobs target players")
public class TargetingFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> followRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Double> xrayConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> instaTargetConfig;
    private final BlacklistConfig entityBlacklistConfig;
    private final List<String> entityBlacklistDefault = Arrays.asList("minecraft:enderman");
    public int followRange = 64;
    public double xray = 0.2;
    public boolean instaTarget = true;
    public ArrayList<IdTagMatcher> entityBlacklist;
    public boolean entityBlacklistAsWhitelist = true;

    public TargetingFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.followRangeConfig = Config.builder.comment("How far away can the mobs see the player. This overrides the vanilla value (16 for most mobs). Setting to 0 will leave the follow range as vanilla.").defineInRange("Follow Range Override", this.followRange, 0, 128);
        this.xrayConfig = Config.builder.comment("Chance for a mob to be able to see players through blocks.").defineInRange("XRay Chance", this.xray, 0.0, 1.0);
        this.instaTargetConfig = Config.builder.comment("Mobs will no longer take random time to target a player.").define("Instant Target", this.instaTarget);
        this.entityBlacklistConfig = new BlacklistConfig(Config.builder, "Entity Blacklist", "Entities in here will not have the TargetAI changed", this.entityBlacklistDefault, false);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.followRange = (Integer)this.followRangeConfig.get();
        this.xray = (Double)this.xrayConfig.get();
        this.instaTarget = (Boolean)this.instaTargetConfig.get();
        this.entityBlacklist = IdTagMatcher.parseStringList((List)((List)this.entityBlacklistConfig.listConfig.get()));
        this.entityBlacklistAsWhitelist = (Boolean)this.entityBlacklistConfig.listAsWhitelistConfig.get();
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)event.getEntity();
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.entityBlacklist) {
            if (!this.entityBlacklistAsWhitelist && blacklistEntry.matchesEntity((Entity)mobEntity)) {
                isInBlacklist = true;
                break;
            }
            if (!blacklistEntry.matchesEntity((Entity)mobEntity)) continue;
            isInWhitelist = true;
            break;
        }
        if (isInBlacklist || !isInWhitelist && this.entityBlacklistAsWhitelist) {
            return;
        }
        if (this.followRange != 0) {
            MCUtils.setAttributeValue((LivingEntity)mobEntity, (Attribute)Attributes.field_233819_b_, (double)this.followRange);
        }
        boolean hasTargetGoal = false;
        Predicate predicate = null;
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (PrioritizedGoal prioritizedGoal : mobEntity.field_70715_bh.field_220892_d) {
            if (!(prioritizedGoal.func_220772_j() instanceof NearestAttackableTargetGoal)) continue;
            NearestAttackableTargetGoal goal = (NearestAttackableTargetGoal)prioritizedGoal.func_220772_j();
            if (goal.field_75307_b != PlayerEntity.class) continue;
            predicate = goal.field_220779_d.field_221023_h;
            goalsToRemove.add(prioritizedGoal.func_220772_j());
            hasTargetGoal = true;
        }
        if (!hasTargetGoal) {
            return;
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)mobEntity.field_70714_bg).func_85156_a(arg_0));
        AINearestAttackableTargetGoal targetGoal = mobEntity instanceof SpiderEntity ? new AINearestAttackableTargetGoal.TargetGoal<PlayerEntity>((SpiderEntity)mobEntity, PlayerEntity.class, true, false, (Predicate<LivingEntity>)predicate) : new AINearestAttackableTargetGoal(mobEntity, PlayerEntity.class, true, false, predicate);
        if (mobEntity.field_70170_p.field_73012_v.nextDouble() < this.xray) {
            targetGoal.setXray(true);
        }
        targetGoal.setInstaTarget(this.instaTarget);
        mobEntity.field_70715_bh.func_75776_a(2, targetGoal);
        AINearestAttackableTargetGoal targetGoalTest = mobEntity instanceof SpiderEntity ? new AINearestAttackableTargetGoal.TargetGoal<EndermiteEntity>((SpiderEntity)mobEntity, EndermiteEntity.class, true, false, (Predicate<LivingEntity>)predicate) : new AINearestAttackableTargetGoal(mobEntity, EndermiteEntity.class, true, false, predicate);
        if (mobEntity.field_70170_p.field_73012_v.nextDouble() < this.xray) {
            targetGoalTest.setXray(true);
        }
        targetGoalTest.setInstaTarget(this.instaTarget);
        mobEntity.field_70715_bh.func_75776_a(2, targetGoalTest);
    }
}

