/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import net.minecraft.entity.EntityClassification;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Base")
public class BaseFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> monstersDespawningDistanceConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minMonstersDespawningDistanceConfig;
    public int monstersDespawningDistance = 80;
    public int minMonstersDespawningDistance = 48;

    public BaseFeature(Module module) {
        super(Config.builder, module, true, false);
        super.pushConfig(Config.builder);
        this.monstersDespawningDistanceConfig = Config.builder.comment("How far away from any player monsters will instantly despawn? Vanilla is 128").defineInRange("Monsters Despawning Distance", this.monstersDespawningDistance, 0, 128);
        this.minMonstersDespawningDistanceConfig = Config.builder.comment("How far away from any player monsters will be able to randomly despawn? Vanilla is 32").defineInRange("Min Monsters Despawning Distance", this.minMonstersDespawningDistance, 0, 128);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.monstersDespawningDistance = (Integer)this.monstersDespawningDistanceConfig.get();
        this.minMonstersDespawningDistance = (Integer)this.minMonstersDespawningDistanceConfig.get();
        EntityClassification.MONSTER.field_233669_n_ = this.monstersDespawningDistance;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMobSpawn(EntityJoinWorldEvent event) {
    }
}

