/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.AIAvoidExplosionGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.TNTEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Avoid Explosions", description="Mobs will run away from exploding creepers / TNT")
public class AvoidExplosionsFeature
extends Feature {
    public AvoidExplosionsFeature(Module module) {
        super(Config.builder, module);
    }

    public void loadConfig() {
        super.loadConfig();
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.addAvoidAI(event);
        this.alertTNT(event);
    }

    private void addAvoidAI(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof CreatureEntity)) {
            return;
        }
        CreatureEntity creatureEntity = (CreatureEntity)event.getEntity();
        creatureEntity.field_70714_bg.func_75776_a(1, (Goal)new AIAvoidExplosionGoal(creatureEntity, 1.6, 1.3));
    }

    private void alertTNT(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof TNTEntity)) {
            return;
        }
        TNTEntity tnt = (TNTEntity)event.getEntity();
        List creaturesNearby = tnt.field_70170_p.func_225317_b(CreatureEntity.class, tnt.func_174813_aQ().func_186662_g(8.0));
        for (CreatureEntity creatureEntity : creaturesNearby) {
            creatureEntity.field_70714_bg.field_220892_d.forEach(prioritizedGoal -> {
                if (prioritizedGoal.func_220772_j() instanceof AIAvoidExplosionGoal) {
                    AIAvoidExplosionGoal aiAvoidExplosionGoal = (AIAvoidExplosionGoal)prioritizedGoal.func_220772_j();
                    aiAvoidExplosionGoal.run((Entity)tnt, 8.0);
                }
            });
        }
    }
}

